#include "univ.h"
#include "master.h"
#include "process.h"
#include "core.h"
#include "dbmonitor/db68000.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "nrtx.h"
#include "dbmon.h"
#include "m68kcore.h"
#include "m68kdbmon.h"
#include "m68knrtx.h"
SRCFILE("m68knrtx.c")

Process	*M68kNrtxMaster::newProcess(Process *pr, char *p, char *s, char* c)
{
	return new M68kNrtxProcess(fd, boardid, pipeid, pr, p, s, c);
}

RtMaster *M68kNrtxMaster::newDbmonMaster()
{
	return new M68kDbmonMaster(fd, boardid, pipeid, parent);
}

M68kNrtxProcess::M68kNrtxProcess(int f, int b, int pid, Process *sib,
  char *p, char *s, char *c) : NrtxProcess(f, b, pid, sib, p, s, c) {}

Core *M68kNrtxProcess::newCore(Master *m)
{
	return new M68kNrtxCore(fd, boardid, pipeid, procid, this, m);
}

M68kNrtxCore::M68kNrtxCore(int f,int b,int p,int i,Process *pr,Master *m):
  Core(pr,m), NrtxCore(f,b,p,i)
{
	regsize = sizeof(DebugRegs);
}
